<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* PrinterProcessingStateDetail File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* PrinterProcessingStateDetail class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class PrinterProcessingStateDetail extends Enum
{
    /**
    * The Enum PrinterProcessingStateDetail
    */
    const PAUSED = "paused";
    const MEDIA_JAM = "mediaJam";
    const MEDIA_NEEDED = "mediaNeeded";
    const MEDIA_LOW = "mediaLow";
    const MEDIA_EMPTY = "mediaEmpty";
    const COVER_OPEN = "coverOpen";
    const INTERLOCK_OPEN = "interlockOpen";
    const OUTPUT_TRAY_MISSING = "outputTrayMissing";
    const OUTPUT_AREA_FULL = "outputAreaFull";
    const MARKER_SUPPLY_LOW = "markerSupplyLow";
    const MARKER_SUPPLY_EMPTY = "markerSupplyEmpty";
    const INPUT_TRAY_MISSING = "inputTrayMissing";
    const OUTPUT_AREA_ALMOST_FULL = "outputAreaAlmostFull";
    const MARKER_WASTE_ALMOST_FULL = "markerWasteAlmostFull";
    const MARKER_WASTE_FULL = "markerWasteFull";
    const FUSER_OVER_TEMP = "fuserOverTemp";
    const FUSER_UNDER_TEMP = "fuserUnderTemp";
    const OTHER = "other";
    const NONE = "none";
    const MOVING_TO_PAUSED = "movingToPaused";
    const SHUTDOWN = "shutdown";
    const CONNECTING_TO_DEVICE = "connectingToDevice";
    const TIMED_OUT = "timedOut";
    const STOPPING = "stopping";
    const STOPPED_PARTIALLY = "stoppedPartially";
    const TONER_LOW = "tonerLow";
    const TONER_EMPTY = "tonerEmpty";
    const SPOOL_AREA_FULL = "spoolAreaFull";
    const DOOR_OPEN = "doorOpen";
    const OPTICAL_PHOTO_CONDUCTOR_NEAR_END_OF_LIFE = "opticalPhotoConductorNearEndOfLife";
    const OPTICAL_PHOTO_CONDUCTOR_LIFE_OVER = "opticalPhotoConductorLifeOver";
    const DEVELOPER_LOW = "developerLow";
    const DEVELOPER_EMPTY = "developerEmpty";
    const INTERPRETER_RESOURCE_UNAVAILABLE = "interpreterResourceUnavailable";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
    const ALERT_REMOVAL_OF_BINARY_CHANGE_ENTRY = "alertRemovalOfBinaryChangeEntry";
    const BANDER_ADDED = "banderAdded";
    const BANDER_ALMOST_EMPTY = "banderAlmostEmpty";
    const BANDER_ALMOST_FULL = "banderAlmostFull";
    const BANDER_AT_LIMIT = "banderAtLimit";
    const BANDER_CLOSED = "banderClosed";
    const BANDER_CONFIGURATION_CHANGE = "banderConfigurationChange";
    const BANDER_COVER_CLOSED = "banderCoverClosed";
    const BANDER_COVER_OPEN = "banderCoverOpen";
    const BANDER_EMPTY = "banderEmpty";
    const BANDER_FULL = "banderFull";
    const BANDER_INTERLOCK_CLOSED = "banderInterlockClosed";
    const BANDER_INTERLOCK_OPEN = "banderInterlockOpen";
    const BANDER_JAM = "banderJam";
    const BANDER_LIFE_ALMOST_OVER = "banderLifeAlmostOver";
    const BANDER_LIFE_OVER = "banderLifeOver";
    const BANDER_MEMORY_EXHAUSTED = "banderMemoryExhausted";
    const BANDER_MISSING = "banderMissing";
    const BANDER_MOTOR_FAILURE = "banderMotorFailure";
    const BANDER_NEAR_LIMIT = "banderNearLimit";
    const BANDER_OFFLINE = "banderOffline";
    const BANDER_OPENED = "banderOpened";
    const BANDER_OVER_TEMPERATURE = "banderOverTemperature";
    const BANDER_POWER_SAVER = "banderPowerSaver";
    const BANDER_RECOVERABLE_FAILURE = "banderRecoverableFailure";
    const BANDER_RECOVERABLE_STORAGE = "banderRecoverableStorage";
    const BANDER_REMOVED = "banderRemoved";
    const BANDER_RESOURCE_ADDED = "banderResourceAdded";
    const BANDER_RESOURCE_REMOVED = "banderResourceRemoved";
    const BANDER_THERMISTOR_FAILURE = "banderThermistorFailure";
    const BANDER_TIMING_FAILURE = "banderTimingFailure";
    const BANDER_TURNED_OFF = "banderTurnedOff";
    const BANDER_TURNED_ON = "banderTurnedOn";
    const BANDER_UNDER_TEMPERATURE = "banderUnderTemperature";
    const BANDER_UNRECOVERABLE_FAILURE = "banderUnrecoverableFailure";
    const BANDER_UNRECOVERABLE_STORAGE_ERROR = "banderUnrecoverableStorageError";
    const BANDER_WARMING_UP = "banderWarmingUp";
    const BINDER_ADDED = "binderAdded";
    const BINDER_ALMOST_EMPTY = "binderAlmostEmpty";
    const BINDER_ALMOST_FULL = "binderAlmostFull";
    const BINDER_AT_LIMIT = "binderAtLimit";
    const BINDER_CLOSED = "binderClosed";
    const BINDER_CONFIGURATION_CHANGE = "binderConfigurationChange";
    const BINDER_COVER_CLOSED = "binderCoverClosed";
    const BINDER_COVER_OPEN = "binderCoverOpen";
    const BINDER_EMPTY = "binderEmpty";
    const BINDER_FULL = "binderFull";
    const BINDER_INTERLOCK_CLOSED = "binderInterlockClosed";
    const BINDER_INTERLOCK_OPEN = "binderInterlockOpen";
    const BINDER_JAM = "binderJam";
    const BINDER_LIFE_ALMOST_OVER = "binderLifeAlmostOver";
    const BINDER_LIFE_OVER = "binderLifeOver";
    const BINDER_MEMORY_EXHAUSTED = "binderMemoryExhausted";
    const BINDER_MISSING = "binderMissing";
    const BINDER_MOTOR_FAILURE = "binderMotorFailure";
    const BINDER_NEAR_LIMIT = "binderNearLimit";
    const BINDER_OFFLINE = "binderOffline";
    const BINDER_OPENED = "binderOpened";
    const BINDER_OVER_TEMPERATURE = "binderOverTemperature";
    const BINDER_POWER_SAVER = "binderPowerSaver";
    const BINDER_RECOVERABLE_FAILURE = "binderRecoverableFailure";
    const BINDER_RECOVERABLE_STORAGE = "binderRecoverableStorage";
    const BINDER_REMOVED = "binderRemoved";
    const BINDER_RESOURCE_ADDED = "binderResourceAdded";
    const BINDER_RESOURCE_REMOVED = "binderResourceRemoved";
    const BINDER_THERMISTOR_FAILURE = "binderThermistorFailure";
    const BINDER_TIMING_FAILURE = "binderTimingFailure";
    const BINDER_TURNED_OFF = "binderTurnedOff";
    const BINDER_TURNED_ON = "binderTurnedOn";
    const BINDER_UNDER_TEMPERATURE = "binderUnderTemperature";
    const BINDER_UNRECOVERABLE_FAILURE = "binderUnrecoverableFailure";
    const BINDER_UNRECOVERABLE_STORAGE_ERROR = "binderUnrecoverableStorageError";
    const BINDER_WARMING_UP = "binderWarmingUp";
    const CAMERA_FAILURE = "cameraFailure";
    const CHAMBER_COOLING = "chamberCooling";
    const CHAMBER_FAILURE = "chamberFailure";
    const CHAMBER_HEATING = "chamberHeating";
    const CHAMBER_TEMPERATURE_HIGH = "chamberTemperatureHigh";
    const CHAMBER_TEMPERATURE_LOW = "chamberTemperatureLow";
    const CLEANER_LIFE_ALMOST_OVER = "cleanerLifeAlmostOver";
    const CLEANER_LIFE_OVER = "cleanerLifeOver";
    const CONFIGURATION_CHANGE = "configurationChange";
    const DEACTIVATED = "deactivated";
    const DELETED = "deleted";
    const DIE_CUTTER_ADDED = "dieCutterAdded";
    const DIE_CUTTER_ALMOST_EMPTY = "dieCutterAlmostEmpty";
    const DIE_CUTTER_ALMOST_FULL = "dieCutterAlmostFull";
    const DIE_CUTTER_AT_LIMIT = "dieCutterAtLimit";
    const DIE_CUTTER_CLOSED = "dieCutterClosed";
    const DIE_CUTTER_CONFIGURATION_CHANGE = "dieCutterConfigurationChange";
    const DIE_CUTTER_COVER_CLOSED = "dieCutterCoverClosed";
    const DIE_CUTTER_COVER_OPEN = "dieCutterCoverOpen";
    const DIE_CUTTER_EMPTY = "dieCutterEmpty";
    const DIE_CUTTER_FULL = "dieCutterFull";
    const DIE_CUTTER_INTERLOCK_CLOSED = "dieCutterInterlockClosed";
    const DIE_CUTTER_INTERLOCK_OPEN = "dieCutterInterlockOpen";
    const DIE_CUTTER_JAM = "dieCutterJam";
    const DIE_CUTTER_LIFE_ALMOST_OVER = "dieCutterLifeAlmostOver";
    const DIE_CUTTER_LIFE_OVER = "dieCutterLifeOver";
    const DIE_CUTTER_MEMORY_EXHAUSTED = "dieCutterMemoryExhausted";
    const DIE_CUTTER_MISSING = "dieCutterMissing";
    const DIE_CUTTER_MOTOR_FAILURE = "dieCutterMotorFailure";
    const DIE_CUTTER_NEAR_LIMIT = "dieCutterNearLimit";
    const DIE_CUTTER_OFFLINE = "dieCutterOffline";
    const DIE_CUTTER_OPENED = "dieCutterOpened";
    const DIE_CUTTER_OVER_TEMPERATURE = "dieCutterOverTemperature";
    const DIE_CUTTER_POWER_SAVER = "dieCutterPowerSaver";
    const DIE_CUTTER_RECOVERABLE_FAILURE = "dieCutterRecoverableFailure";
    const DIE_CUTTER_RECOVERABLE_STORAGE = "dieCutterRecoverableStorage";
    const DIE_CUTTER_REMOVED = "dieCutterRemoved";
    const DIE_CUTTER_RESOURCE_ADDED = "dieCutterResourceAdded";
    const DIE_CUTTER_RESOURCE_REMOVED = "dieCutterResourceRemoved";
    const DIE_CUTTER_THERMISTOR_FAILURE = "dieCutterThermistorFailure";
    const DIE_CUTTER_TIMING_FAILURE = "dieCutterTimingFailure";
    const DIE_CUTTER_TURNED_OFF = "dieCutterTurnedOff";
    const DIE_CUTTER_TURNED_ON = "dieCutterTurnedOn";
    const DIE_CUTTER_UNDER_TEMPERATURE = "dieCutterUnderTemperature";
    const DIE_CUTTER_UNRECOVERABLE_FAILURE = "dieCutterUnrecoverableFailure";
    const DIE_CUTTER_UNRECOVERABLE_STORAGE_ERROR = "dieCutterUnrecoverableStorageError";
    const DIE_CUTTER_WARMING_UP = "dieCutterWarmingUp";
    const EXTRUDER_COOLING = "extruderCooling";
    const EXTRUDER_FAILURE = "extruderFailure";
    const EXTRUDER_HEATING = "extruderHeating";
    const EXTRUDER_JAM = "extruderJam";
    const EXTRUDER_TEMPERATURE_HIGH = "extruderTemperatureHigh";
    const EXTRUDER_TEMPERATURE_LOW = "extruderTemperatureLow";
    const FAN_FAILURE = "fanFailure";
    const FAX_MODEM_LIFE_ALMOST_OVER = "faxModemLifeAlmostOver";
    const FAX_MODEM_LIFE_OVER = "faxModemLifeOver";
    const FAX_MODEM_MISSING = "faxModemMissing";
    const FAX_MODEM_TURNED_OFF = "faxModemTurnedOff";
    const FAX_MODEM_TURNED_ON = "faxModemTurnedOn";
    const FOLDER_ADDED = "folderAdded";
    const FOLDER_ALMOST_EMPTY = "folderAlmostEmpty";
    const FOLDER_ALMOST_FULL = "folderAlmostFull";
    const FOLDER_AT_LIMIT = "folderAtLimit";
    const FOLDER_CLOSED = "folderClosed";
    const FOLDER_CONFIGURATION_CHANGE = "folderConfigurationChange";
    const FOLDER_COVER_CLOSED = "folderCoverClosed";
    const FOLDER_COVER_OPEN = "folderCoverOpen";
    const FOLDER_EMPTY = "folderEmpty";
    const FOLDER_FULL = "folderFull";
    const FOLDER_INTERLOCK_CLOSED = "folderInterlockClosed";
    const FOLDER_INTERLOCK_OPEN = "folderInterlockOpen";
    const FOLDER_JAM = "folderJam";
    const FOLDER_LIFE_ALMOST_OVER = "folderLifeAlmostOver";
    const FOLDER_LIFE_OVER = "folderLifeOver";
    const FOLDER_MEMORY_EXHAUSTED = "folderMemoryExhausted";
    const FOLDER_MISSING = "folderMissing";
    const FOLDER_MOTOR_FAILURE = "folderMotorFailure";
    const FOLDER_NEAR_LIMIT = "folderNearLimit";
    const FOLDER_OFFLINE = "folderOffline";
    const FOLDER_OPENED = "folderOpened";
    const FOLDER_OVER_TEMPERATURE = "folderOverTemperature";
    const FOLDER_POWER_SAVER = "folderPowerSaver";
    const FOLDER_RECOVERABLE_FAILURE = "folderRecoverableFailure";
    const FOLDER_RECOVERABLE_STORAGE = "folderRecoverableStorage";
    const FOLDER_REMOVED = "folderRemoved";
    const FOLDER_RESOURCE_ADDED = "folderResourceAdded";
    const FOLDER_RESOURCE_REMOVED = "folderResourceRemoved";
    const FOLDER_THERMISTOR_FAILURE = "folderThermistorFailure";
    const FOLDER_TIMING_FAILURE = "folderTimingFailure";
    const FOLDER_TURNED_OFF = "folderTurnedOff";
    const FOLDER_TURNED_ON = "folderTurnedOn";
    const FOLDER_UNDER_TEMPERATURE = "folderUnderTemperature";
    const FOLDER_UNRECOVERABLE_FAILURE = "folderUnrecoverableFailure";
    const FOLDER_UNRECOVERABLE_STORAGE_ERROR = "folderUnrecoverableStorageError";
    const FOLDER_WARMING_UP = "folderWarmingUp";
    const HIBERNATE = "hibernate";
    const HOLD_NEW_JOBS = "holdNewJobs";
    const IDENTIFY_PRINTER_REQUESTED = "identifyPrinterRequested";
    const IMPRINTER_ADDED = "imprinterAdded";
    const IMPRINTER_ALMOST_EMPTY = "imprinterAlmostEmpty";
    const IMPRINTER_ALMOST_FULL = "imprinterAlmostFull";
    const IMPRINTER_AT_LIMIT = "imprinterAtLimit";
    const IMPRINTER_CLOSED = "imprinterClosed";
    const IMPRINTER_CONFIGURATION_CHANGE = "imprinterConfigurationChange";
    const IMPRINTER_COVER_CLOSED = "imprinterCoverClosed";
    const IMPRINTER_COVER_OPEN = "imprinterCoverOpen";
    const IMPRINTER_EMPTY = "imprinterEmpty";
    const IMPRINTER_FULL = "imprinterFull";
    const IMPRINTER_INTERLOCK_CLOSED = "imprinterInterlockClosed";
    const IMPRINTER_INTERLOCK_OPEN = "imprinterInterlockOpen";
    const IMPRINTER_JAM = "imprinterJam";
    const IMPRINTER_LIFE_ALMOST_OVER = "imprinterLifeAlmostOver";
    const IMPRINTER_LIFE_OVER = "imprinterLifeOver";
    const IMPRINTER_MEMORY_EXHAUSTED = "imprinterMemoryExhausted";
    const IMPRINTER_MISSING = "imprinterMissing";
    const IMPRINTER_MOTOR_FAILURE = "imprinterMotorFailure";
    const IMPRINTER_NEAR_LIMIT = "imprinterNearLimit";
    const IMPRINTER_OFFLINE = "imprinterOffline";
    const IMPRINTER_OPENED = "imprinterOpened";
    const IMPRINTER_OVER_TEMPERATURE = "imprinterOverTemperature";
    const IMPRINTER_POWER_SAVER = "imprinterPowerSaver";
    const IMPRINTER_RECOVERABLE_FAILURE = "imprinterRecoverableFailure";
    const IMPRINTER_RECOVERABLE_STORAGE = "imprinterRecoverableStorage";
    const IMPRINTER_REMOVED = "imprinterRemoved";
    const IMPRINTER_RESOURCE_ADDED = "imprinterResourceAdded";
    const IMPRINTER_RESOURCE_REMOVED = "imprinterResourceRemoved";
    const IMPRINTER_THERMISTOR_FAILURE = "imprinterThermistorFailure";
    const IMPRINTER_TIMING_FAILURE = "imprinterTimingFailure";
    const IMPRINTER_TURNED_OFF = "imprinterTurnedOff";
    const IMPRINTER_TURNED_ON = "imprinterTurnedOn";
    const IMPRINTER_UNDER_TEMPERATURE = "imprinterUnderTemperature";
    const IMPRINTER_UNRECOVERABLE_FAILURE = "imprinterUnrecoverableFailure";
    const IMPRINTER_UNRECOVERABLE_STORAGE_ERROR = "imprinterUnrecoverableStorageError";
    const IMPRINTER_WARMING_UP = "imprinterWarmingUp";
    const INPUT_CANNOT_FEED_SIZE_SELECTED = "inputCannotFeedSizeSelected";
    const INPUT_MANUAL_INPUT_REQUEST = "inputManualInputRequest";
    const INPUT_MEDIA_COLOR_CHANGE = "inputMediaColorChange";
    const INPUT_MEDIA_FORM_PARTS_CHANGE = "inputMediaFormPartsChange";
    const INPUT_MEDIA_SIZE_CHANGE = "inputMediaSizeChange";
    const INPUT_MEDIA_TRAY_FAILURE = "inputMediaTrayFailure";
    const INPUT_MEDIA_TRAY_FEED_ERROR = "inputMediaTrayFeedError";
    const INPUT_MEDIA_TRAY_JAM = "inputMediaTrayJam";
    const INPUT_MEDIA_TYPE_CHANGE = "inputMediaTypeChange";
    const INPUT_MEDIA_WEIGHT_CHANGE = "inputMediaWeightChange";
    const INPUT_PICK_ROLLER_FAILURE = "inputPickRollerFailure";
    const INPUT_PICK_ROLLER_LIFE_OVER = "inputPickRollerLifeOver";
    const INPUT_PICK_ROLLER_LIFE_WARN = "inputPickRollerLifeWarn";
    const INPUT_PICK_ROLLER_MISSING = "inputPickRollerMissing";
    const INPUT_TRAY_ELEVATION_FAILURE = "inputTrayElevationFailure";
    const INPUT_TRAY_POSITION_FAILURE = "inputTrayPositionFailure";
    const INSERTER_ADDED = "inserterAdded";
    const INSERTER_ALMOST_EMPTY = "inserterAlmostEmpty";
    const INSERTER_ALMOST_FULL = "inserterAlmostFull";
    const INSERTER_AT_LIMIT = "inserterAtLimit";
    const INSERTER_CLOSED = "inserterClosed";
    const INSERTER_CONFIGURATION_CHANGE = "inserterConfigurationChange";
    const INSERTER_COVER_CLOSED = "inserterCoverClosed";
    const INSERTER_COVER_OPEN = "inserterCoverOpen";
    const INSERTER_EMPTY = "inserterEmpty";
    const INSERTER_FULL = "inserterFull";
    const INSERTER_INTERLOCK_CLOSED = "inserterInterlockClosed";
    const INSERTER_INTERLOCK_OPEN = "inserterInterlockOpen";
    const INSERTER_JAM = "inserterJam";
    const INSERTER_LIFE_ALMOST_OVER = "inserterLifeAlmostOver";
    const INSERTER_LIFE_OVER = "inserterLifeOver";
    const INSERTER_MEMORY_EXHAUSTED = "inserterMemoryExhausted";
    const INSERTER_MISSING = "inserterMissing";
    const INSERTER_MOTOR_FAILURE = "inserterMotorFailure";
    const INSERTER_NEAR_LIMIT = "inserterNearLimit";
    const INSERTER_OFFLINE = "inserterOffline";
    const INSERTER_OPENED = "inserterOpened";
    const INSERTER_OVER_TEMPERATURE = "inserterOverTemperature";
    const INSERTER_POWER_SAVER = "inserterPowerSaver";
    const INSERTER_RECOVERABLE_FAILURE = "inserterRecoverableFailure";
    const INSERTER_RECOVERABLE_STORAGE = "inserterRecoverableStorage";
    const INSERTER_REMOVED = "inserterRemoved";
    const INSERTER_RESOURCE_ADDED = "inserterResourceAdded";
    const INSERTER_RESOURCE_REMOVED = "inserterResourceRemoved";
    const INSERTER_THERMISTOR_FAILURE = "inserterThermistorFailure";
    const INSERTER_TIMING_FAILURE = "inserterTimingFailure";
    const INSERTER_TURNED_OFF = "inserterTurnedOff";
    const INSERTER_TURNED_ON = "inserterTurnedOn";
    const INSERTER_UNDER_TEMPERATURE = "inserterUnderTemperature";
    const INSERTER_UNRECOVERABLE_FAILURE = "inserterUnrecoverableFailure";
    const INSERTER_UNRECOVERABLE_STORAGE_ERROR = "inserterUnrecoverableStorageError";
    const INSERTER_WARMING_UP = "inserterWarmingUp";
    const INTERLOCK_CLOSED = "interlockClosed";
    const INTERPRETER_CARTRIDGE_ADDED = "interpreterCartridgeAdded";
    const INTERPRETER_CARTRIDGE_DELETED = "interpreterCartridgeDeleted";
    const INTERPRETER_COMPLEX_PAGE_ENCOUNTERED = "interpreterComplexPageEncountered";
    const INTERPRETER_MEMORY_DECREASE = "interpreterMemoryDecrease";
    const INTERPRETER_MEMORY_INCREASE = "interpreterMemoryIncrease";
    const INTERPRETER_RESOURCE_ADDED = "interpreterResourceAdded";
    const INTERPRETER_RESOURCE_DELETED = "interpreterResourceDeleted";
    const LAMP_AT_EOL = "lampAtEol";
    const LAMP_FAILURE = "lampFailure";
    const LAMP_NEAR_EOL = "lampNearEol";
    const LASER_AT_EOL = "laserAtEol";
    const LASER_FAILURE = "laserFailure";
    const LASER_NEAR_EOL = "laserNearEol";
    const MAKE_ENVELOPE_ADDED = "makeEnvelopeAdded";
    const MAKE_ENVELOPE_ALMOST_EMPTY = "makeEnvelopeAlmostEmpty";
    const MAKE_ENVELOPE_ALMOST_FULL = "makeEnvelopeAlmostFull";
    const MAKE_ENVELOPE_AT_LIMIT = "makeEnvelopeAtLimit";
    const MAKE_ENVELOPE_CLOSED = "makeEnvelopeClosed";
    const MAKE_ENVELOPE_CONFIGURATION_CHANGE = "makeEnvelopeConfigurationChange";
    const MAKE_ENVELOPE_COVER_CLOSED = "makeEnvelopeCoverClosed";
    const MAKE_ENVELOPE_COVER_OPEN = "makeEnvelopeCoverOpen";
    const MAKE_ENVELOPE_EMPTY = "makeEnvelopeEmpty";
    const MAKE_ENVELOPE_FULL = "makeEnvelopeFull";
    const MAKE_ENVELOPE_INTERLOCK_CLOSED = "makeEnvelopeInterlockClosed";
    const MAKE_ENVELOPE_INTERLOCK_OPEN = "makeEnvelopeInterlockOpen";
    const MAKE_ENVELOPE_JAM = "makeEnvelopeJam";
    const MAKE_ENVELOPE_LIFE_ALMOST_OVER = "makeEnvelopeLifeAlmostOver";
    const MAKE_ENVELOPE_LIFE_OVER = "makeEnvelopeLifeOver";
    const MAKE_ENVELOPE_MEMORY_EXHAUSTED = "makeEnvelopeMemoryExhausted";
    const MAKE_ENVELOPE_MISSING = "makeEnvelopeMissing";
    const MAKE_ENVELOPE_MOTOR_FAILURE = "makeEnvelopeMotorFailure";
    const MAKE_ENVELOPE_NEAR_LIMIT = "makeEnvelopeNearLimit";
    const MAKE_ENVELOPE_OFFLINE = "makeEnvelopeOffline";
    const MAKE_ENVELOPE_OPENED = "makeEnvelopeOpened";
    const MAKE_ENVELOPE_OVER_TEMPERATURE = "makeEnvelopeOverTemperature";
    const MAKE_ENVELOPE_POWER_SAVER = "makeEnvelopePowerSaver";
    const MAKE_ENVELOPE_RECOVERABLE_FAILURE = "makeEnvelopeRecoverableFailure";
    const MAKE_ENVELOPE_RECOVERABLE_STORAGE = "makeEnvelopeRecoverableStorage";
    const MAKE_ENVELOPE_REMOVED = "makeEnvelopeRemoved";
    const MAKE_ENVELOPE_RESOURCE_ADDED = "makeEnvelopeResourceAdded";
    const MAKE_ENVELOPE_RESOURCE_REMOVED = "makeEnvelopeResourceRemoved";
    const MAKE_ENVELOPE_THERMISTOR_FAILURE = "makeEnvelopeThermistorFailure";
    const MAKE_ENVELOPE_TIMING_FAILURE = "makeEnvelopeTimingFailure";
    const MAKE_ENVELOPE_TURNED_OFF = "makeEnvelopeTurnedOff";
    const MAKE_ENVELOPE_TURNED_ON = "makeEnvelopeTurnedOn";
    const MAKE_ENVELOPE_UNDER_TEMPERATURE = "makeEnvelopeUnderTemperature";
    const MAKE_ENVELOPE_UNRECOVERABLE_FAILURE = "makeEnvelopeUnrecoverableFailure";
    const MAKE_ENVELOPE_UNRECOVERABLE_STORAGE_ERROR = "makeEnvelopeUnrecoverableStorageError";
    const MAKE_ENVELOPE_WARMING_UP = "makeEnvelopeWarmingUp";
    const MARKER_ADJUSTING_PRINT_QUALITY = "markerAdjustingPrintQuality";
    const MARKER_CLEANER_MISSING = "markerCleanerMissing";
    const MARKER_DEVELOPER_ALMOST_EMPTY = "markerDeveloperAlmostEmpty";
    const MARKER_DEVELOPER_EMPTY = "markerDeveloperEmpty";
    const MARKER_DEVELOPER_MISSING = "markerDeveloperMissing";
    const MARKER_FUSER_MISSING = "markerFuserMissing";
    const MARKER_FUSER_THERMISTOR_FAILURE = "markerFuserThermistorFailure";
    const MARKER_FUSER_TIMING_FAILURE = "markerFuserTimingFailure";
    const MARKER_INK_ALMOST_EMPTY = "markerInkAlmostEmpty";
    const MARKER_INK_EMPTY = "markerInkEmpty";
    const MARKER_INK_MISSING = "markerInkMissing";
    const MARKER_OPC_MISSING = "markerOpcMissing";
    const MARKER_PRINT_RIBBON_ALMOST_EMPTY = "markerPrintRibbonAlmostEmpty";
    const MARKER_PRINT_RIBBON_EMPTY = "markerPrintRibbonEmpty";
    const MARKER_PRINT_RIBBON_MISSING = "markerPrintRibbonMissing";
    const MARKER_SUPPLY_ALMOST_EMPTY = "markerSupplyAlmostEmpty";
    const MARKER_SUPPLY_MISSING = "markerSupplyMissing";
    const MARKER_TONER_CARTRIDGE_MISSING = "markerTonerCartridgeMissing";
    const MARKER_TONER_MISSING = "markerTonerMissing";
    const MARKER_WASTE_INK_RECEPTACLE_ALMOST_FULL = "markerWasteInkReceptacleAlmostFull";
    const MARKER_WASTE_INK_RECEPTACLE_FULL = "markerWasteInkReceptacleFull";
    const MARKER_WASTE_INK_RECEPTACLE_MISSING = "markerWasteInkReceptacleMissing";
    const MARKER_WASTE_MISSING = "markerWasteMissing";
    const MARKER_WASTE_TONER_RECEPTACLE_ALMOST_FULL = "markerWasteTonerReceptacleAlmostFull";
    const MARKER_WASTE_TONER_RECEPTACLE_FULL = "markerWasteTonerReceptacleFull";
    const MARKER_WASTE_TONER_RECEPTACLE_MISSING = "markerWasteTonerReceptacleMissing";
    const MATERIAL_EMPTY = "materialEmpty";
    const MATERIAL_LOW = "materialLow";
    const MATERIAL_NEEDED = "materialNeeded";
    const MEDIA_DRYING = "mediaDrying";
    const MEDIA_PATH_CANNOT_DUPLEX_MEDIA_SELECTED = "mediaPathCannotDuplexMediaSelected";
    const MEDIA_PATH_FAILURE = "mediaPathFailure";
    const MEDIA_PATH_INPUT_EMPTY = "mediaPathInputEmpty";
    const MEDIA_PATH_INPUT_FEED_ERROR = "mediaPathInputFeedError";
    const MEDIA_PATH_INPUT_JAM = "mediaPathInputJam";
    const MEDIA_PATH_INPUT_REQUEST = "mediaPathInputRequest";
    const MEDIA_PATH_JAM = "mediaPathJam";
    const MEDIA_PATH_MEDIA_TRAY_ALMOST_FULL = "mediaPathMediaTrayAlmostFull";
    const MEDIA_PATH_MEDIA_TRAY_FULL = "mediaPathMediaTrayFull";
    const MEDIA_PATH_MEDIA_TRAY_MISSING = "mediaPathMediaTrayMissing";
    const MEDIA_PATH_OUTPUT_FEED_ERROR = "mediaPathOutputFeedError";
    const MEDIA_PATH_OUTPUT_FULL = "mediaPathOutputFull";
    const MEDIA_PATH_OUTPUT_JAM = "mediaPathOutputJam";
    const MEDIA_PATH_PICK_ROLLER_FAILURE = "mediaPathPickRollerFailure";
    const MEDIA_PATH_PICK_ROLLER_LIFE_OVER = "mediaPathPickRollerLifeOver";
    const MEDIA_PATH_PICK_ROLLER_LIFE_WARN = "mediaPathPickRollerLifeWarn";
    const MEDIA_PATH_PICK_ROLLER_MISSING = "mediaPathPickRollerMissing";
    const MOTOR_FAILURE = "motorFailure";
    const OUTPUT_MAILBOX_SELECT_FAILURE = "outputMailboxSelectFailure";
    const OUTPUT_MEDIA_TRAY_FAILURE = "outputMediaTrayFailure";
    const OUTPUT_MEDIA_TRAY_FEED_ERROR = "outputMediaTrayFeedError";
    const OUTPUT_MEDIA_TRAY_JAM = "outputMediaTrayJam";
    const PERFORATER_ADDED = "perforaterAdded";
    const PERFORATER_ALMOST_EMPTY = "perforaterAlmostEmpty";
    const PERFORATER_ALMOST_FULL = "perforaterAlmostFull";
    const PERFORATER_AT_LIMIT = "perforaterAtLimit";
    const PERFORATER_CLOSED = "perforaterClosed";
    const PERFORATER_CONFIGURATION_CHANGE = "perforaterConfigurationChange";
    const PERFORATER_COVER_CLOSED = "perforaterCoverClosed";
    const PERFORATER_COVER_OPEN = "perforaterCoverOpen";
    const PERFORATER_EMPTY = "perforaterEmpty";
    const PERFORATER_FULL = "perforaterFull";
    const PERFORATER_INTERLOCK_CLOSED = "perforaterInterlockClosed";
    const PERFORATER_INTERLOCK_OPEN = "perforaterInterlockOpen";
    const PERFORATER_JAM = "perforaterJam";
    const PERFORATER_LIFE_ALMOST_OVER = "perforaterLifeAlmostOver";
    const PERFORATER_LIFE_OVER = "perforaterLifeOver";
    const PERFORATER_MEMORY_EXHAUSTED = "perforaterMemoryExhausted";
    const PERFORATER_MISSING = "perforaterMissing";
    const PERFORATER_MOTOR_FAILURE = "perforaterMotorFailure";
    const PERFORATER_NEAR_LIMIT = "perforaterNearLimit";
    const PERFORATER_OFFLINE = "perforaterOffline";
    const PERFORATER_OPENED = "perforaterOpened";
    const PERFORATER_OVER_TEMPERATURE = "perforaterOverTemperature";
    const PERFORATER_POWER_SAVER = "perforaterPowerSaver";
    const PERFORATER_RECOVERABLE_FAILURE = "perforaterRecoverableFailure";
    const PERFORATER_RECOVERABLE_STORAGE = "perforaterRecoverableStorage";
    const PERFORATER_REMOVED = "perforaterRemoved";
    const PERFORATER_RESOURCE_ADDED = "perforaterResourceAdded";
    const PERFORATER_RESOURCE_REMOVED = "perforaterResourceRemoved";
    const PERFORATER_THERMISTOR_FAILURE = "perforaterThermistorFailure";
    const PERFORATER_TIMING_FAILURE = "perforaterTimingFailure";
    const PERFORATER_TURNED_OFF = "perforaterTurnedOff";
    const PERFORATER_TURNED_ON = "perforaterTurnedOn";
    const PERFORATER_UNDER_TEMPERATURE = "perforaterUnderTemperature";
    const PERFORATER_UNRECOVERABLE_FAILURE = "perforaterUnrecoverableFailure";
    const PERFORATER_UNRECOVERABLE_STORAGE_ERROR = "perforaterUnrecoverableStorageError";
    const PERFORATER_WARMING_UP = "perforaterWarmingUp";
    const PLATFORM_COOLING = "platformCooling";
    const PLATFORM_FAILURE = "platformFailure";
    const PLATFORM_HEATING = "platformHeating";
    const PLATFORM_TEMPERATURE_HIGH = "platformTemperatureHigh";
    const PLATFORM_TEMPERATURE_LOW = "platformTemperatureLow";
    const POWER_DOWN = "powerDown";
    const POWER_UP = "powerUp";
    const PRINTER_MANUAL_RESET = "printerManualReset";
    const PRINTER_NMS_RESET = "printerNmsReset";
    const PRINTER_READY_TO_PRINT = "printerReadyToPrint";
    const PUNCHER_ADDED = "puncherAdded";
    const PUNCHER_ALMOST_EMPTY = "puncherAlmostEmpty";
    const PUNCHER_ALMOST_FULL = "puncherAlmostFull";
    const PUNCHER_AT_LIMIT = "puncherAtLimit";
    const PUNCHER_CLOSED = "puncherClosed";
    const PUNCHER_CONFIGURATION_CHANGE = "puncherConfigurationChange";
    const PUNCHER_COVER_CLOSED = "puncherCoverClosed";
    const PUNCHER_COVER_OPEN = "puncherCoverOpen";
    const PUNCHER_EMPTY = "puncherEmpty";
    const PUNCHER_FULL = "puncherFull";
    const PUNCHER_INTERLOCK_CLOSED = "puncherInterlockClosed";
    const PUNCHER_INTERLOCK_OPEN = "puncherInterlockOpen";
    const PUNCHER_JAM = "puncherJam";
    const PUNCHER_LIFE_ALMOST_OVER = "puncherLifeAlmostOver";
    const PUNCHER_LIFE_OVER = "puncherLifeOver";
    const PUNCHER_MEMORY_EXHAUSTED = "puncherMemoryExhausted";
    const PUNCHER_MISSING = "puncherMissing";
    const PUNCHER_MOTOR_FAILURE = "puncherMotorFailure";
    const PUNCHER_NEAR_LIMIT = "puncherNearLimit";
    const PUNCHER_OFFLINE = "puncherOffline";
    const PUNCHER_OPENED = "puncherOpened";
    const PUNCHER_OVER_TEMPERATURE = "puncherOverTemperature";
    const PUNCHER_POWER_SAVER = "puncherPowerSaver";
    const PUNCHER_RECOVERABLE_FAILURE = "puncherRecoverableFailure";
    const PUNCHER_RECOVERABLE_STORAGE = "puncherRecoverableStorage";
    const PUNCHER_REMOVED = "puncherRemoved";
    const PUNCHER_RESOURCE_ADDED = "puncherResourceAdded";
    const PUNCHER_RESOURCE_REMOVED = "puncherResourceRemoved";
    const PUNCHER_THERMISTOR_FAILURE = "puncherThermistorFailure";
    const PUNCHER_TIMING_FAILURE = "puncherTimingFailure";
    const PUNCHER_TURNED_OFF = "puncherTurnedOff";
    const PUNCHER_TURNED_ON = "puncherTurnedOn";
    const PUNCHER_UNDER_TEMPERATURE = "puncherUnderTemperature";
    const PUNCHER_UNRECOVERABLE_FAILURE = "puncherUnrecoverableFailure";
    const PUNCHER_UNRECOVERABLE_STORAGE_ERROR = "puncherUnrecoverableStorageError";
    const PUNCHER_WARMING_UP = "puncherWarmingUp";
    const RESUMING = "resuming";
    const SCAN_MEDIA_PATH_FAILURE = "scanMediaPathFailure";
    const SCAN_MEDIA_PATH_INPUT_EMPTY = "scanMediaPathInputEmpty";
    const SCAN_MEDIA_PATH_INPUT_FEED_ERROR = "scanMediaPathInputFeedError";
    const SCAN_MEDIA_PATH_INPUT_JAM = "scanMediaPathInputJam";
    const SCAN_MEDIA_PATH_INPUT_REQUEST = "scanMediaPathInputRequest";
    const SCAN_MEDIA_PATH_JAM = "scanMediaPathJam";
    const SCAN_MEDIA_PATH_OUTPUT_FEED_ERROR = "scanMediaPathOutputFeedError";
    const SCAN_MEDIA_PATH_OUTPUT_FULL = "scanMediaPathOutputFull";
    const SCAN_MEDIA_PATH_OUTPUT_JAM = "scanMediaPathOutputJam";
    const SCAN_MEDIA_PATH_PICK_ROLLER_FAILURE = "scanMediaPathPickRollerFailure";
    const SCAN_MEDIA_PATH_PICK_ROLLER_LIFE_OVER = "scanMediaPathPickRollerLifeOver";
    const SCAN_MEDIA_PATH_PICK_ROLLER_LIFE_WARN = "scanMediaPathPickRollerLifeWarn";
    const SCAN_MEDIA_PATH_PICK_ROLLER_MISSING = "scanMediaPathPickRollerMissing";
    const SCAN_MEDIA_PATH_TRAY_ALMOST_FULL = "scanMediaPathTrayAlmostFull";
    const SCAN_MEDIA_PATH_TRAY_FULL = "scanMediaPathTrayFull";
    const SCAN_MEDIA_PATH_TRAY_MISSING = "scanMediaPathTrayMissing";
    const SCANNER_LIGHT_FAILURE = "scannerLightFailure";
    const SCANNER_LIGHT_LIFE_ALMOST_OVER = "scannerLightLifeAlmostOver";
    const SCANNER_LIGHT_LIFE_OVER = "scannerLightLifeOver";
    const SCANNER_LIGHT_MISSING = "scannerLightMissing";
    const SCANNER_SENSOR_FAILURE = "scannerSensorFailure";
    const SCANNER_SENSOR_LIFE_ALMOST_OVER = "scannerSensorLifeAlmostOver";
    const SCANNER_SENSOR_LIFE_OVER = "scannerSensorLifeOver";
    const SCANNER_SENSOR_MISSING = "scannerSensorMissing";
    const SEPARATION_CUTTER_ADDED = "separationCutterAdded";
    const SEPARATION_CUTTER_ALMOST_EMPTY = "separationCutterAlmostEmpty";
    const SEPARATION_CUTTER_ALMOST_FULL = "separationCutterAlmostFull";
    const SEPARATION_CUTTER_AT_LIMIT = "separationCutterAtLimit";
    const SEPARATION_CUTTER_CLOSED = "separationCutterClosed";
    const SEPARATION_CUTTER_CONFIGURATION_CHANGE = "separationCutterConfigurationChange";
    const SEPARATION_CUTTER_COVER_CLOSED = "separationCutterCoverClosed";
    const SEPARATION_CUTTER_COVER_OPEN = "separationCutterCoverOpen";
    const SEPARATION_CUTTER_EMPTY = "separationCutterEmpty";
    const SEPARATION_CUTTER_FULL = "separationCutterFull";
    const SEPARATION_CUTTER_INTERLOCK_CLOSED = "separationCutterInterlockClosed";
    const SEPARATION_CUTTER_INTERLOCK_OPEN = "separationCutterInterlockOpen";
    const SEPARATION_CUTTER_JAM = "separationCutterJam";
    const SEPARATION_CUTTER_LIFE_ALMOST_OVER = "separationCutterLifeAlmostOver";
    const SEPARATION_CUTTER_LIFE_OVER = "separationCutterLifeOver";
    const SEPARATION_CUTTER_MEMORY_EXHAUSTED = "separationCutterMemoryExhausted";
    const SEPARATION_CUTTER_MISSING = "separationCutterMissing";
    const SEPARATION_CUTTER_MOTOR_FAILURE = "separationCutterMotorFailure";
    const SEPARATION_CUTTER_NEAR_LIMIT = "separationCutterNearLimit";
    const SEPARATION_CUTTER_OFFLINE = "separationCutterOffline";
    const SEPARATION_CUTTER_OPENED = "separationCutterOpened";
    const SEPARATION_CUTTER_OVER_TEMPERATURE = "separationCutterOverTemperature";
    const SEPARATION_CUTTER_POWER_SAVER = "separationCutterPowerSaver";
    const SEPARATION_CUTTER_RECOVERABLE_FAILURE = "separationCutterRecoverableFailure";
    const SEPARATION_CUTTER_RECOVERABLE_STORAGE = "separationCutterRecoverableStorage";
    const SEPARATION_CUTTER_REMOVED = "separationCutterRemoved";
    const SEPARATION_CUTTER_RESOURCE_ADDED = "separationCutterResourceAdded";
    const SEPARATION_CUTTER_RESOURCE_REMOVED = "separationCutterResourceRemoved";
    const SEPARATION_CUTTER_THERMISTOR_FAILURE = "separationCutterThermistorFailure";
    const SEPARATION_CUTTER_TIMING_FAILURE = "separationCutterTimingFailure";
    const SEPARATION_CUTTER_TURNED_OFF = "separationCutterTurnedOff";
    const SEPARATION_CUTTER_TURNED_ON = "separationCutterTurnedOn";
    const SEPARATION_CUTTER_UNDER_TEMPERATURE = "separationCutterUnderTemperature";
    const SEPARATION_CUTTER_UNRECOVERABLE_FAILURE = "separationCutterUnrecoverableFailure";
    const SEPARATION_CUTTER_UNRECOVERABLE_STORAGE_ERROR = "separationCutterUnrecoverableStorageError";
    const SEPARATION_CUTTER_WARMING_UP = "separationCutterWarmingUp";
    const SHEET_ROTATOR_ADDED = "sheetRotatorAdded";
    const SHEET_ROTATOR_ALMOST_EMPTY = "sheetRotatorAlmostEmpty";
    const SHEET_ROTATOR_ALMOST_FULL = "sheetRotatorAlmostFull";
    const SHEET_ROTATOR_AT_LIMIT = "sheetRotatorAtLimit";
    const SHEET_ROTATOR_CLOSED = "sheetRotatorClosed";
    const SHEET_ROTATOR_CONFIGURATION_CHANGE = "sheetRotatorConfigurationChange";
    const SHEET_ROTATOR_COVER_CLOSED = "sheetRotatorCoverClosed";
    const SHEET_ROTATOR_COVER_OPEN = "sheetRotatorCoverOpen";
    const SHEET_ROTATOR_EMPTY = "sheetRotatorEmpty";
    const SHEET_ROTATOR_FULL = "sheetRotatorFull";
    const SHEET_ROTATOR_INTERLOCK_CLOSED = "sheetRotatorInterlockClosed";
    const SHEET_ROTATOR_INTERLOCK_OPEN = "sheetRotatorInterlockOpen";
    const SHEET_ROTATOR_JAM = "sheetRotatorJam";
    const SHEET_ROTATOR_LIFE_ALMOST_OVER = "sheetRotatorLifeAlmostOver";
    const SHEET_ROTATOR_LIFE_OVER = "sheetRotatorLifeOver";
    const SHEET_ROTATOR_MEMORY_EXHAUSTED = "sheetRotatorMemoryExhausted";
    const SHEET_ROTATOR_MISSING = "sheetRotatorMissing";
    const SHEET_ROTATOR_MOTOR_FAILURE = "sheetRotatorMotorFailure";
    const SHEET_ROTATOR_NEAR_LIMIT = "sheetRotatorNearLimit";
    const SHEET_ROTATOR_OFFLINE = "sheetRotatorOffline";
    const SHEET_ROTATOR_OPENED = "sheetRotatorOpened";
    const SHEET_ROTATOR_OVER_TEMPERATURE = "sheetRotatorOverTemperature";
    const SHEET_ROTATOR_POWER_SAVER = "sheetRotatorPowerSaver";
    const SHEET_ROTATOR_RECOVERABLE_FAILURE = "sheetRotatorRecoverableFailure";
    const SHEET_ROTATOR_RECOVERABLE_STORAGE = "sheetRotatorRecoverableStorage";
    const SHEET_ROTATOR_REMOVED = "sheetRotatorRemoved";
    const SHEET_ROTATOR_RESOURCE_ADDED = "sheetRotatorResourceAdded";
    const SHEET_ROTATOR_RESOURCE_REMOVED = "sheetRotatorResourceRemoved";
    const SHEET_ROTATOR_THERMISTOR_FAILURE = "sheetRotatorThermistorFailure";
    const SHEET_ROTATOR_TIMING_FAILURE = "sheetRotatorTimingFailure";
    const SHEET_ROTATOR_TURNED_OFF = "sheetRotatorTurnedOff";
    const SHEET_ROTATOR_TURNED_ON = "sheetRotatorTurnedOn";
    const SHEET_ROTATOR_UNDER_TEMPERATURE = "sheetRotatorUnderTemperature";
    const SHEET_ROTATOR_UNRECOVERABLE_FAILURE = "sheetRotatorUnrecoverableFailure";
    const SHEET_ROTATOR_UNRECOVERABLE_STORAGE_ERROR = "sheetRotatorUnrecoverableStorageError";
    const SHEET_ROTATOR_WARMING_UP = "sheetRotatorWarmingUp";
    const SLITTER_ADDED = "slitterAdded";
    const SLITTER_ALMOST_EMPTY = "slitterAlmostEmpty";
    const SLITTER_ALMOST_FULL = "slitterAlmostFull";
    const SLITTER_AT_LIMIT = "slitterAtLimit";
    const SLITTER_CLOSED = "slitterClosed";
    const SLITTER_CONFIGURATION_CHANGE = "slitterConfigurationChange";
    const SLITTER_COVER_CLOSED = "slitterCoverClosed";
    const SLITTER_COVER_OPEN = "slitterCoverOpen";
    const SLITTER_EMPTY = "slitterEmpty";
    const SLITTER_FULL = "slitterFull";
    const SLITTER_INTERLOCK_CLOSED = "slitterInterlockClosed";
    const SLITTER_INTERLOCK_OPEN = "slitterInterlockOpen";
    const SLITTER_JAM = "slitterJam";
    const SLITTER_LIFE_ALMOST_OVER = "slitterLifeAlmostOver";
    const SLITTER_LIFE_OVER = "slitterLifeOver";
    const SLITTER_MEMORY_EXHAUSTED = "slitterMemoryExhausted";
    const SLITTER_MISSING = "slitterMissing";
    const SLITTER_MOTOR_FAILURE = "slitterMotorFailure";
    const SLITTER_NEAR_LIMIT = "slitterNearLimit";
    const SLITTER_OFFLINE = "slitterOffline";
    const SLITTER_OPENED = "slitterOpened";
    const SLITTER_OVER_TEMPERATURE = "slitterOverTemperature";
    const SLITTER_POWER_SAVER = "slitterPowerSaver";
    const SLITTER_RECOVERABLE_FAILURE = "slitterRecoverableFailure";
    const SLITTER_RECOVERABLE_STORAGE = "slitterRecoverableStorage";
    const SLITTER_REMOVED = "slitterRemoved";
    const SLITTER_RESOURCE_ADDED = "slitterResourceAdded";
    const SLITTER_RESOURCE_REMOVED = "slitterResourceRemoved";
    const SLITTER_THERMISTOR_FAILURE = "slitterThermistorFailure";
    const SLITTER_TIMING_FAILURE = "slitterTimingFailure";
    const SLITTER_TURNED_OFF = "slitterTurnedOff";
    const SLITTER_TURNED_ON = "slitterTurnedOn";
    const SLITTER_UNDER_TEMPERATURE = "slitterUnderTemperature";
    const SLITTER_UNRECOVERABLE_FAILURE = "slitterUnrecoverableFailure";
    const SLITTER_UNRECOVERABLE_STORAGE_ERROR = "slitterUnrecoverableStorageError";
    const SLITTER_WARMING_UP = "slitterWarmingUp";
    const STACKER_ADDED = "stackerAdded";
    const STACKER_ALMOST_EMPTY = "stackerAlmostEmpty";
    const STACKER_ALMOST_FULL = "stackerAlmostFull";
    const STACKER_AT_LIMIT = "stackerAtLimit";
    const STACKER_CLOSED = "stackerClosed";
    const STACKER_CONFIGURATION_CHANGE = "stackerConfigurationChange";
    const STACKER_COVER_CLOSED = "stackerCoverClosed";
    const STACKER_COVER_OPEN = "stackerCoverOpen";
    const STACKER_EMPTY = "stackerEmpty";
    const STACKER_FULL = "stackerFull";
    const STACKER_INTERLOCK_CLOSED = "stackerInterlockClosed";
    const STACKER_INTERLOCK_OPEN = "stackerInterlockOpen";
    const STACKER_JAM = "stackerJam";
    const STACKER_LIFE_ALMOST_OVER = "stackerLifeAlmostOver";
    const STACKER_LIFE_OVER = "stackerLifeOver";
    const STACKER_MEMORY_EXHAUSTED = "stackerMemoryExhausted";
    const STACKER_MISSING = "stackerMissing";
    const STACKER_MOTOR_FAILURE = "stackerMotorFailure";
    const STACKER_NEAR_LIMIT = "stackerNearLimit";
    const STACKER_OFFLINE = "stackerOffline";
    const STACKER_OPENED = "stackerOpened";
    const STACKER_OVER_TEMPERATURE = "stackerOverTemperature";
    const STACKER_POWER_SAVER = "stackerPowerSaver";
    const STACKER_RECOVERABLE_FAILURE = "stackerRecoverableFailure";
    const STACKER_RECOVERABLE_STORAGE = "stackerRecoverableStorage";
    const STACKER_REMOVED = "stackerRemoved";
    const STACKER_RESOURCE_ADDED = "stackerResourceAdded";
    const STACKER_RESOURCE_REMOVED = "stackerResourceRemoved";
    const STACKER_THERMISTOR_FAILURE = "stackerThermistorFailure";
    const STACKER_TIMING_FAILURE = "stackerTimingFailure";
    const STACKER_TURNED_OFF = "stackerTurnedOff";
    const STACKER_TURNED_ON = "stackerTurnedOn";
    const STACKER_UNDER_TEMPERATURE = "stackerUnderTemperature";
    const STACKER_UNRECOVERABLE_FAILURE = "stackerUnrecoverableFailure";
    const STACKER_UNRECOVERABLE_STORAGE_ERROR = "stackerUnrecoverableStorageError";
    const STACKER_WARMING_UP = "stackerWarmingUp";
    const STANDBY = "standby";
    const STAPLER_ADDED = "staplerAdded";
    const STAPLER_ALMOST_EMPTY = "staplerAlmostEmpty";
    const STAPLER_ALMOST_FULL = "staplerAlmostFull";
    const STAPLER_AT_LIMIT = "staplerAtLimit";
    const STAPLER_CLOSED = "staplerClosed";
    const STAPLER_CONFIGURATION_CHANGE = "staplerConfigurationChange";
    const STAPLER_COVER_CLOSED = "staplerCoverClosed";
    const STAPLER_COVER_OPEN = "staplerCoverOpen";
    const STAPLER_EMPTY = "staplerEmpty";
    const STAPLER_FULL = "staplerFull";
    const STAPLER_INTERLOCK_CLOSED = "staplerInterlockClosed";
    const STAPLER_INTERLOCK_OPEN = "staplerInterlockOpen";
    const STAPLER_JAM = "staplerJam";
    const STAPLER_LIFE_ALMOST_OVER = "staplerLifeAlmostOver";
    const STAPLER_LIFE_OVER = "staplerLifeOver";
    const STAPLER_MEMORY_EXHAUSTED = "staplerMemoryExhausted";
    const STAPLER_MISSING = "staplerMissing";
    const STAPLER_MOTOR_FAILURE = "staplerMotorFailure";
    const STAPLER_NEAR_LIMIT = "staplerNearLimit";
    const STAPLER_OFFLINE = "staplerOffline";
    const STAPLER_OPENED = "staplerOpened";
    const STAPLER_OVER_TEMPERATURE = "staplerOverTemperature";
    const STAPLER_POWER_SAVER = "staplerPowerSaver";
    const STAPLER_RECOVERABLE_FAILURE = "staplerRecoverableFailure";
    const STAPLER_RECOVERABLE_STORAGE = "staplerRecoverableStorage";
    const STAPLER_REMOVED = "staplerRemoved";
    const STAPLER_RESOURCE_ADDED = "staplerResourceAdded";
    const STAPLER_RESOURCE_REMOVED = "staplerResourceRemoved";
    const STAPLER_THERMISTOR_FAILURE = "staplerThermistorFailure";
    const STAPLER_TIMING_FAILURE = "staplerTimingFailure";
    const STAPLER_TURNED_OFF = "staplerTurnedOff";
    const STAPLER_TURNED_ON = "staplerTurnedOn";
    const STAPLER_UNDER_TEMPERATURE = "staplerUnderTemperature";
    const STAPLER_UNRECOVERABLE_FAILURE = "staplerUnrecoverableFailure";
    const STAPLER_UNRECOVERABLE_STORAGE_ERROR = "staplerUnrecoverableStorageError";
    const STAPLER_WARMING_UP = "staplerWarmingUp";
    const STITCHER_ADDED = "stitcherAdded";
    const STITCHER_ALMOST_EMPTY = "stitcherAlmostEmpty";
    const STITCHER_ALMOST_FULL = "stitcherAlmostFull";
    const STITCHER_AT_LIMIT = "stitcherAtLimit";
    const STITCHER_CLOSED = "stitcherClosed";
    const STITCHER_CONFIGURATION_CHANGE = "stitcherConfigurationChange";
    const STITCHER_COVER_CLOSED = "stitcherCoverClosed";
    const STITCHER_COVER_OPEN = "stitcherCoverOpen";
    const STITCHER_EMPTY = "stitcherEmpty";
    const STITCHER_FULL = "stitcherFull";
    const STITCHER_INTERLOCK_CLOSED = "stitcherInterlockClosed";
    const STITCHER_INTERLOCK_OPEN = "stitcherInterlockOpen";
    const STITCHER_JAM = "stitcherJam";
    const STITCHER_LIFE_ALMOST_OVER = "stitcherLifeAlmostOver";
    const STITCHER_LIFE_OVER = "stitcherLifeOver";
    const STITCHER_MEMORY_EXHAUSTED = "stitcherMemoryExhausted";
    const STITCHER_MISSING = "stitcherMissing";
    const STITCHER_MOTOR_FAILURE = "stitcherMotorFailure";
    const STITCHER_NEAR_LIMIT = "stitcherNearLimit";
    const STITCHER_OFFLINE = "stitcherOffline";
    const STITCHER_OPENED = "stitcherOpened";
    const STITCHER_OVER_TEMPERATURE = "stitcherOverTemperature";
    const STITCHER_POWER_SAVER = "stitcherPowerSaver";
    const STITCHER_RECOVERABLE_FAILURE = "stitcherRecoverableFailure";
    const STITCHER_RECOVERABLE_STORAGE = "stitcherRecoverableStorage";
    const STITCHER_REMOVED = "stitcherRemoved";
    const STITCHER_RESOURCE_ADDED = "stitcherResourceAdded";
    const STITCHER_RESOURCE_REMOVED = "stitcherResourceRemoved";
    const STITCHER_THERMISTOR_FAILURE = "stitcherThermistorFailure";
    const STITCHER_TIMING_FAILURE = "stitcherTimingFailure";
    const STITCHER_TURNED_OFF = "stitcherTurnedOff";
    const STITCHER_TURNED_ON = "stitcherTurnedOn";
    const STITCHER_UNDER_TEMPERATURE = "stitcherUnderTemperature";
    const STITCHER_UNRECOVERABLE_FAILURE = "stitcherUnrecoverableFailure";
    const STITCHER_UNRECOVERABLE_STORAGE_ERROR = "stitcherUnrecoverableStorageError";
    const STITCHER_WARMING_UP = "stitcherWarmingUp";
    const SUBUNIT_ADDED = "subunitAdded";
    const SUBUNIT_ALMOST_EMPTY = "subunitAlmostEmpty";
    const SUBUNIT_ALMOST_FULL = "subunitAlmostFull";
    const SUBUNIT_AT_LIMIT = "subunitAtLimit";
    const SUBUNIT_CLOSED = "subunitClosed";
    const SUBUNIT_COOLING_DOWN = "subunitCoolingDown";
    const SUBUNIT_EMPTY = "subunitEmpty";
    const SUBUNIT_FULL = "subunitFull";
    const SUBUNIT_LIFE_ALMOST_OVER = "subunitLifeAlmostOver";
    const SUBUNIT_LIFE_OVER = "subunitLifeOver";
    const SUBUNIT_MEMORY_EXHAUSTED = "subunitMemoryExhausted";
    const SUBUNIT_MISSING = "subunitMissing";
    const SUBUNIT_MOTOR_FAILURE = "subunitMotorFailure";
    const SUBUNIT_NEAR_LIMIT = "subunitNearLimit";
    const SUBUNIT_OFFLINE = "subunitOffline";
    const SUBUNIT_OPENED = "subunitOpened";
    const SUBUNIT_OVER_TEMPERATURE = "subunitOverTemperature";
    const SUBUNIT_POWER_SAVER = "subunitPowerSaver";
    const SUBUNIT_RECOVERABLE_FAILURE = "subunitRecoverableFailure";
    const SUBUNIT_RECOVERABLE_STORAGE = "subunitRecoverableStorage";
    const SUBUNIT_REMOVED = "subunitRemoved";
    const SUBUNIT_RESOURCE_ADDED = "subunitResourceAdded";
    const SUBUNIT_RESOURCE_REMOVED = "subunitResourceRemoved";
    const SUBUNIT_THERMISTOR_FAILURE = "subunitThermistorFailure";
    const SUBUNIT_TIMING_FAILURE = "subunitTimingFailure";
    const SUBUNIT_TURNED_OFF = "subunitTurnedOff";
    const SUBUNIT_TURNED_ON = "subunitTurnedOn";
    const SUBUNIT_UNDER_TEMPERATURE = "subunitUnderTemperature";
    const SUBUNIT_UNRECOVERABLE_FAILURE = "subunitUnrecoverableFailure";
    const SUBUNIT_UNRECOVERABLE_STORAGE = "subunitUnrecoverableStorage";
    const SUBUNIT_WARMING_UP = "subunitWarmingUp";
    const SUSPEND = "suspend";
    const TESTING = "testing";
    const TRIMMER_ADDED = "trimmerAdded";
    const TRIMMER_ALMOST_EMPTY = "trimmerAlmostEmpty";
    const TRIMMER_ALMOST_FULL = "trimmerAlmostFull";
    const TRIMMER_AT_LIMIT = "trimmerAtLimit";
    const TRIMMER_CLOSED = "trimmerClosed";
    const TRIMMER_CONFIGURATION_CHANGE = "trimmerConfigurationChange";
    const TRIMMER_COVER_CLOSED = "trimmerCoverClosed";
    const TRIMMER_COVER_OPEN = "trimmerCoverOpen";
    const TRIMMER_EMPTY = "trimmerEmpty";
    const TRIMMER_FULL = "trimmerFull";
    const TRIMMER_INTERLOCK_CLOSED = "trimmerInterlockClosed";
    const TRIMMER_INTERLOCK_OPEN = "trimmerInterlockOpen";
    const TRIMMER_JAM = "trimmerJam";
    const TRIMMER_LIFE_ALMOST_OVER = "trimmerLifeAlmostOver";
    const TRIMMER_LIFE_OVER = "trimmerLifeOver";
    const TRIMMER_MEMORY_EXHAUSTED = "trimmerMemoryExhausted";
    const TRIMMER_MISSING = "trimmerMissing";
    const TRIMMER_MOTOR_FAILURE = "trimmerMotorFailure";
    const TRIMMER_NEAR_LIMIT = "trimmerNearLimit";
    const TRIMMER_OFFLINE = "trimmerOffline";
    const TRIMMER_OPENED = "trimmerOpened";
    const TRIMMER_OVER_TEMPERATURE = "trimmerOverTemperature";
    const TRIMMER_POWER_SAVER = "trimmerPowerSaver";
    const TRIMMER_RECOVERABLE_FAILURE = "trimmerRecoverableFailure";
    const TRIMMER_RECOVERABLE_STORAGE = "trimmerRecoverableStorage";
    const TRIMMER_REMOVED = "trimmerRemoved";
    const TRIMMER_RESOURCE_ADDED = "trimmerResourceAdded";
    const TRIMMER_RESOURCE_REMOVED = "trimmerResourceRemoved";
    const TRIMMER_THERMISTOR_FAILURE = "trimmerThermistorFailure";
    const TRIMMER_TIMING_FAILURE = "trimmerTimingFailure";
    const TRIMMER_TURNED_OFF = "trimmerTurnedOff";
    const TRIMMER_TURNED_ON = "trimmerTurnedOn";
    const TRIMMER_UNDER_TEMPERATURE = "trimmerUnderTemperature";
    const TRIMMER_UNRECOVERABLE_FAILURE = "trimmerUnrecoverableFailure";
    const TRIMMER_UNRECOVERABLE_STORAGE_ERROR = "trimmerUnrecoverableStorageError";
    const TRIMMER_WARMING_UP = "trimmerWarmingUp";
    const UNKNOWN = "unknown";
    const WRAPPER_ADDED = "wrapperAdded";
    const WRAPPER_ALMOST_EMPTY = "wrapperAlmostEmpty";
    const WRAPPER_ALMOST_FULL = "wrapperAlmostFull";
    const WRAPPER_AT_LIMIT = "wrapperAtLimit";
    const WRAPPER_CLOSED = "wrapperClosed";
    const WRAPPER_CONFIGURATION_CHANGE = "wrapperConfigurationChange";
    const WRAPPER_COVER_CLOSED = "wrapperCoverClosed";
    const WRAPPER_COVER_OPEN = "wrapperCoverOpen";
    const WRAPPER_EMPTY = "wrapperEmpty";
    const WRAPPER_FULL = "wrapperFull";
    const WRAPPER_INTERLOCK_CLOSED = "wrapperInterlockClosed";
    const WRAPPER_INTERLOCK_OPEN = "wrapperInterlockOpen";
    const WRAPPER_JAM = "wrapperJam";
    const WRAPPER_LIFE_ALMOST_OVER = "wrapperLifeAlmostOver";
    const WRAPPER_LIFE_OVER = "wrapperLifeOver";
    const WRAPPER_MEMORY_EXHAUSTED = "wrapperMemoryExhausted";
    const WRAPPER_MISSING = "wrapperMissing";
    const WRAPPER_MOTOR_FAILURE = "wrapperMotorFailure";
    const WRAPPER_NEAR_LIMIT = "wrapperNearLimit";
    const WRAPPER_OFFLINE = "wrapperOffline";
    const WRAPPER_OPENED = "wrapperOpened";
    const WRAPPER_OVER_TEMPERATURE = "wrapperOverTemperature";
    const WRAPPER_POWER_SAVER = "wrapperPowerSaver";
    const WRAPPER_RECOVERABLE_FAILURE = "wrapperRecoverableFailure";
    const WRAPPER_RECOVERABLE_STORAGE = "wrapperRecoverableStorage";
    const WRAPPER_REMOVED = "wrapperRemoved";
    const WRAPPER_RESOURCE_ADDED = "wrapperResourceAdded";
    const WRAPPER_RESOURCE_REMOVED = "wrapperResourceRemoved";
    const WRAPPER_THERMISTOR_FAILURE = "wrapperThermistorFailure";
    const WRAPPER_TIMING_FAILURE = "wrapperTimingFailure";
    const WRAPPER_TURNED_OFF = "wrapperTurnedOff";
    const WRAPPER_TURNED_ON = "wrapperTurnedOn";
    const WRAPPER_UNDER_TEMPERATURE = "wrapperUnderTemperature";
    const WRAPPER_UNRECOVERABLE_FAILURE = "wrapperUnrecoverableFailure";
    const WRAPPER_UNRECOVERABLE_STORAGE_ERROR = "wrapperUnrecoverableStorageError";
    const WRAPPER_WARMING_UP = "wrapperWarmingUp";
}
